package gov.va.med.mhv.admin.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import gov.va.med.mhv.admin.model.Visn;
import gov.va.med.mhv.admin.model.VisnLookup;

public interface VisnRepository extends JpaRepository<VisnLookup, Long> {

	@Query("select visnLookup from VisnLookup visnLookup " + "where visnLookup.postalCode = :postalCode ")
	public VisnLookup getVisnLookupByPostalCode(@Param("postalCode") String postalCode);

	@Query("select visnLookup from VisnLookup visnLookup ")
	public List<VisnLookup> getAllPostalCode();
	
	@Query("select visn from Visn visn  order by visn.visnId ")
	public List<Visn> getAllVisns();

}
